<?xml version="1.0" encoding="iso-8859-1" ?>
  <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      version="1.0">
  <!-- xsl:include href="/home/jochen/sgml/slides-2.0a2/xsl/frames.xsl" / -->
  <xsl:include href="/home/jochen/sgml/slides-2.0a2/xsl/slides.xsl"/>
  <!-- xsl:include href="/home/jochen/sgml/slides-2.0a2/xsl/slides.xsl" / -->
  <!-- xsl:include
  href="/home/jochen/sgml/slides-2.0a1/xsl/fo-plain.xsl" / -->
  <!-- Hey Emacs, this is -*- xml-mode -*- -->

  <!-- *jcw, 6/6/00: suppress remarks -->
  <!-- xsl:variable name="show.comments">0</xsl:variable -->

<!-- section-top-nav hnlich machen -->
<xsl:template name="section-top-nav">
  <xsl:param name="prev-target" select="''"/>
  <xsl:param name="next-target" select="''"/>

  <xsl:variable name="section" select="ancestor::section"/>

  <xsl:variable name="nextfoil">
    <xsl:apply-templates select="(following::foil
                                 |following::section)[1]"
                         mode="filename"/>
  </xsl:variable>

  <xsl:variable name="prevfoil">
    <xsl:choose>
      <xsl:when test="preceding-sibling::foil">
        <xsl:apply-templates select="preceding-sibling::foil[1]"
                             mode="filename"/>
      </xsl:when>
      <xsl:when test="parent::section">
        <xsl:apply-templates select="parent::section[1]"
                             mode="filename"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$titlefoil.html"/>
        <!-- xsl:value-of select="title"/ -->
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <div class="navhead">
    <table WIDTH="100%" heigth="100%" BGCOLOR="#66FFFF" NOSAVE="NOSAVE" >
      <tr>
        <td WIDTH="100%" style="vertical-align:top">
          <table COLS="1" WIDTH="100%" HEIGHT="100%" BGCOLOR="#66FFFF" NOSAVE="NOSAVE">
            <tr>
              <td valign="top" style="vertical-align:top">
                <table COLS="3" WIDTH="100%" HEIGHT="100%" BGCOLOR="#33CCFF" NOSAVE="NOSAVE" >
                  <tr>
                    <td>
                      <xsl:choose>
                        <xsl:when test="$prevfoil != ''">
                          <a href="{$prevfoil}">
                            <xsl:if test="$prev-target != ''">
                              <xsl:attribute name="target">
                                <xsl:value-of select="$prev-target"/>
                              </xsl:attribute>
                            </xsl:if>
                            <xsl:choose>
                              <xsl:when test="preceding-sibling::foil">
                                <xsl:value-of select="preceding-sibling::foil[1]/title"/>
                              </xsl:when>
                              <xsl:when test="parent::section">
                                <xsl:value-of select="parent::section[1]/title"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="/slides/slidesinfo/title"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </a>
                        </xsl:when>
                        <xsl:otherwise>&#160;</xsl:otherwise>
                      </xsl:choose>
                    </td>
                    <!-- td ALIGN="CENTER" VALIGN="CENTER"
		      NOSAVE="NOSAVE"><xsl:value-of
		      select="title"/></td -->
                    <td ALIGN="CENTER" VALIGN="CENTER"
			NOSAVE="NOSAVE">&#160;</td>
                    <td ALIGN="RIGHT">
                      <xsl:choose>
                        <xsl:when test="$nextfoil != ''">
                          <a href="{$nextfoil}">
                            <xsl:if test="$next-target != ''">
                              <xsl:attribute name="target">
                                <xsl:value-of select="$next-target"/>
                              </xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="(following::foil
                                                  |following::section)[1]/title"/>
                          </a>
                        </xsl:when>
                        <xsl:otherwise>&#160;</xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td ALIGN="CENTER" VALIGN="CENTER" NOSAVE="NOSAVE" style="vertical-align:middle">
                <b>
                  <font size="+1">
                    <xsl:value-of select="title"/>
                  </font>
                </b>
              </td>
            </tr>
          </table>
        </td>
        <td width="88" ALIGN="RIGHT">
          <img SRC="logo.jpg" ALT="LUG Kassel [Logo]" NOSAVE="NOSAVE"/>
          <!--     height="66" width="66"/ -->
        </td>
      </tr>
    </table>
  </div>
</xsl:template>

<xsl:template name="foil-top-nav">
  <xsl:param name="prev-target" select="''"/>
  <xsl:param name="next-target" select="''"/>

  <xsl:variable name="section" select="ancestor::section"/>

  <xsl:variable name="nextfoil">
    <xsl:apply-templates select="(following::foil
                                 |following::section)[1]"
                         mode="filename"/>
  </xsl:variable>

  <xsl:variable name="prevfoil">
    <xsl:choose>
      <xsl:when test="preceding-sibling::foil">
        <xsl:apply-templates select="preceding-sibling::foil[1]"
                             mode="filename"/>
      </xsl:when>
      <xsl:when test="parent::section">
        <xsl:apply-templates select="parent::section[1]"
                             mode="filename"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$titlefoil.html"/>
        <!-- xsl:value-of select="title"/ -->
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <div class="navhead">
    <table WIDTH="100%" BGCOLOR="#66FFFF" NOSAVE="NOSAVE" >
      <tr>
        <td width="100%">
          <table COLS="1" WIDTH="100%" HEIGHT="30" BGCOLOR="#66FFFF" NOSAVE="NOSAVE">
            <tr>
              <td valign="top">
                <table COLS="3" WIDTH="100%" BGCOLOR="#33CCFF" NOSAVE="NOSAVE" >
                  <tr>
                    <td>
                      <xsl:choose>
                        <xsl:when test="$prevfoil != ''">
                          <a href="{$prevfoil}">
                            <xsl:if test="$prev-target != ''">
                              <xsl:attribute name="target">
                                <xsl:value-of select="$prev-target"/>
                              </xsl:attribute>
                            </xsl:if>
                            <xsl:choose>
                              <xsl:when test="preceding-sibling::foil">
                                <xsl:value-of select="preceding-sibling::foil[1]/title"/>
                              </xsl:when>
                              <xsl:when test="parent::section">
                                <xsl:value-of select="parent::section[1]/title"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="/slides/slidesinfo/title"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </a>
                        </xsl:when>
                        <xsl:otherwise>&#160;</xsl:otherwise>
                      </xsl:choose>
                    </td>
                    <!-- td ALIGN="CENTER" VALIGN="CENTER"
		      NOSAVE="NOSAVE"><xsl:value-of
		      select="title"/></td -->
                    <td ALIGN="CENTER" VALIGN="CENTER"
			NOSAVE="NOSAVE">&#160;</td>
                    <td ALIGN="RIGHT">
                      <xsl:choose>
                        <xsl:when test="$nextfoil != ''">
                          <a href="{$nextfoil}">
                            <xsl:if test="$next-target != ''">
                              <xsl:attribute name="target">
                                <xsl:value-of select="$next-target"/>
                              </xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="(following::foil
                                                  |following::section)[1]/title"/>
                          </a>
                        </xsl:when>
                        <xsl:otherwise>&#160;</xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td ALIGN="CENTER" VALIGN="CENTER" NOSAVE="NOSAVE">
                <b>
                  <font size="+1">
                    <xsl:value-of select="title"/>
                  </font>
                </b>
              </td>
            </tr>
          </table>
        </td>
        <td align="RIGHT">
          <img width="88" SRC="logo.jpg" ALT="LUG Kassel [Logo]" NOSAVE="NOSAVE"/>
          <!--     height="66" width="66"/ -->
        </td>
      </tr>
    </table>
  </div>
</xsl:template>

<xsl:template match="slides/foil/title">
  <!-- h1 class="{name(.)}"><xsl:apply-templates/></h1 -->
</xsl:template>

</xsl:stylesheet>

